﻿#include  "StdAfx.h"

#include  "PasswordUI.hpp"
#include  "Resource.h"
#include  "PasswordDialog.hpp"
#include  "ProcessUI.hpp"

PasswordUI::PasswordUI(ProcessUI *pUI) : password(), pUI(pUI)
{
}

PasswordUI::~PasswordUI()
{
}

LRESULT GetPasswordFunc(void * ptr)
{
  CPasswordDialog *dlg = (CPasswordDialog *)ptr;
  return dlg->DoModal();
}

int PasswordUI::GetPassword(const szstring &archivePath, szstring *password, bool *skipAll)
{
  CPasswordDialog pwdDialog(archivePath, this->password);
  pUI->Invoke(GetPasswordFunc, &pwdDialog);
  int retval = pwdDialog.GetReturnCode();
  if (retval == IDCANCEL)
    return PasswordResult::PASSWORD_CANCEL;
  else if (retval == IDOK)
  {
    password->assign(pwdDialog.GetPassword());
    this->password.assign(*password);
    return PasswordResult::PASSWORD_OK;
  }
  else if (retval == IDC_SKIP_ALL_BUTTON)
    *skipAll = true;
  return PasswordResult::PASSWORD_SKIP;
}
